%Script prova metodo GFDM - flusso a potenziale attorno NACA-0012
%Equazione Laplace - stazionario - 2D
%Predefined connectivity
%Scritto da Pavan Andrea - 16/07/2022
clear;
clc;

%% dati input
airfoilNpoints = 100;
boundaryRadius = 20;     %raggio bordo esterno
boundaryNpoints = 50;      %numero punti bordo esterno
lmax = 5;        %distanza massima punti
searchdist = 1e-6;      %distanza ricerca punti
Nminsat = 8;        %numero minimo satelliti


%% generazione geometria
%nodi profilo
boundaryNodes{1} = naca4_generator('0012',airfoilNpoints);

%nodi contorno
boundaryNodes{2}(:,1) = 0.25 + boundaryRadius*cos(0:(2*pi/boundaryNpoints):2*pi);
boundaryNodes{2}(:,2) = boundaryRadius*sin(0:(2*pi/boundaryNpoints):2*pi);
boundaryNodes{2}(end,:) = [];


%% generazione pointcloud
P = generate_pointcloud_2(boundaryNodes,'boolInternal',[false true],'nextrasteps',0,'lmax',lmax);
P = [boundaryNodes{1}; boundaryNodes{2}; P];
lbo = length(boundaryNodes);

figure();
plot(P(:,1),P(:,2),'k.');
title('Grafico pointcloud');
xlabel('x');
ylabel('y');


%% popolamento stelle
Psatidx = [];        %elenco punti satellite
Nsat = zeros(length(P),1);      %numero punti satellite
for i=1:length(P)
    %cerco i satelliti del punto i
    searchdisti = searchdist;
    while Nsat(i)<Nminsat
        %Psatidx{i} = find((abs(P(:,1)-P(i,1))<=searchdisti).*(abs(P(:,2)-P(i,2))<=searchdisti).*((P(:,1)-P(i,1)).^2+(P(:,2)-P(i,2)).^2>2*eps));
        Psatidx{i} = find(((P(:,1)-P(i,1)).^2+(P(:,2)-P(i,2)).^2<=searchdisti).*((P(:,1)-P(i,1)).^2+(P(:,2)-P(i,2)).^2>2*eps));
        Nsat(i) = length(Psatidx{i});
        searchdisti = searchdisti*1.1;
    end
end

%calcolo distanze satelliti
h = [];     %distanza x satelliti
k = [];     %distanza y satelliti
for i=1:length(P)
    h{i} = zeros(Nsat(i),1);
    k{i} = zeros(Nsat(i),1);
    for j=1:Nsat(i)
        h{i}(j) = P(Psatidx{i}(j),1)-P(i,1);
        k{i}(j) = P(Psatidx{i}(j),2)-P(i,2);
    end
end


%% grafico connettività stelle
figure();
plot(P(:,1),P(:,2),'k.','MarkerSize',10);
hold on;
for i=1:10:length(P)
    linecolor = [rand rand rand];
    for j=1:length(Psatidx{i})
        plot([P(i,1),P(Psatidx{i}(j),1)],[P(i,2),P(Psatidx{i}(j),2)],'-','Color',linecolor);
    end
end
title('Esempio connettività pointcloud');
xlabel('x [m]');
ylabel('y [m]');
axis equal;
%axis square;
hold off;

